/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStringNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;
    private static final DefaultStringNormalizer NORMALIZER = new DefaultStringNormalizer();

    @Override
    public Value<?> normalize(Value<?> value) throws NamingException {
        String str = value.getString();
        if (StringTools.isEmpty(str)) {
            return new ClientStringValue(str);
        }
        if (str.charAt(0) == '#') {
            return new ClientStringValue(StringTools.decodeHexString(str));
        }
        if (str.indexOf(92) != -1) {
            return new ClientStringValue(StringTools.decodeEscapedHex(str));
        }
        return new ClientStringValue(str);
    }

    @Override
    public String normalize(String value) throws NamingException {
        if (StringTools.isEmpty(value)) {
            return value;
        }
        if (value.charAt(0) == '#') {
            return StringTools.decodeHexString(value);
        }
        if (value.indexOf(92) != -1) {
            return StringTools.decodeEscapedHex(value);
        }
        return value;
    }

    public static String normalizeString(String string) throws NamingException {
        return NORMALIZER.normalize(string);
    }
}

