/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxes;

import org.apache.directory.shared.ldap.schema.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class BitStringSyntaxChecker
extends AbstractSyntaxChecker {
    public BitStringSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.6");
    }

    protected BitStringSyntaxChecker(String oid) {
        super(oid);
    }

    public static boolean isValid(String strValue) {
        if (strValue.length() == 0) {
            return false;
        }
        int pos = 0;
        if (!StringTools.isCharASCII(strValue, pos++, '\'')) {
            return false;
        }
        if (!StringTools.isBit(strValue, pos++)) {
            return false;
        }
        while (StringTools.isBit(strValue, pos)) {
            ++pos;
        }
        if (!StringTools.isCharASCII(strValue, pos++, '\'')) {
            return false;
        }
        return StringTools.isCharASCII(strValue, pos, 'B');
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        return BitStringSyntaxChecker.isValid(strValue);
    }
}

