/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.unboundid.scim2.client.requests.RequestBuilder;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;

public class DeleteRequestBuilder
extends RequestBuilder<DeleteRequestBuilder> {
    @Nullable
    private String version;

    public DeleteRequestBuilder(@NotNull WebTarget target) {
        super(target);
    }

    @NotNull
    public DeleteRequestBuilder ifMatch(@Nullable String version) {
        this.version = version;
        return this;
    }

    @Override
    @NotNull
    Invocation.Builder buildRequest() {
        Invocation.Builder request = super.buildRequest();
        if (this.version != null) {
            request.header("If-Match", (Object)this.version);
        }
        return request;
    }

    public void invoke() throws ScimException {
        try (Response response = this.buildRequest().delete();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                throw DeleteRequestBuilder.toScimException(response);
            }
        }
    }
}

