/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.unboundid.scim2.client.requests.RequestBuilder;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.utils.StaticUtils;
import jakarta.ws.rs.client.WebTarget;
import java.util.Set;

public abstract class ResourceReturningRequestBuilder<T extends ResourceReturningRequestBuilder>
extends RequestBuilder<T> {
    protected boolean excluded;
    @Nullable
    protected Set<String> attributes;

    ResourceReturningRequestBuilder(@NotNull WebTarget target) {
        super(target);
    }

    @Override
    @NotNull
    WebTarget buildTarget() {
        if (this.attributes != null && this.attributes.size() > 0) {
            if (!this.excluded) {
                return super.buildTarget().queryParam("attributes", new Object[]{StaticUtils.collectionToString(this.attributes, (String)",")});
            }
            return super.buildTarget().queryParam("excludedAttributes", new Object[]{StaticUtils.collectionToString(this.attributes, (String)",")});
        }
        return super.buildTarget();
    }

    @NotNull
    public T attributes(String ... attributes) {
        this.attributes = StaticUtils.arrayToSet((Object[])attributes);
        return (T)this;
    }

    @NotNull
    public T excludedAttributes(String ... excludedAttributes) {
        this.attributes = StaticUtils.arrayToSet((Object[])excludedAttributes);
        this.excluded = true;
        return (T)this;
    }
}

