/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

public class AttributeDefinition {
    @NotNull
    @Attribute(description="The attribute's name.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final String name;
    @NotNull
    @Attribute(description="The attribute's data type.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final Type type;
    @Nullable
    @Attribute(description="When an attribute is of type \"complex\", \"subAttributes\" defines set of sub-attributes.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE, multiValueClass=AttributeDefinition.class)
    private final Collection<AttributeDefinition> subAttributes;
    @Attribute(description="Boolean value indicating the attribute's plurality.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final boolean multiValued;
    @Nullable
    @Attribute(description="The attribute's human readable description.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final String description;
    @Attribute(description="A Boolean value that specifies if the attribute is required.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final boolean required;
    @Nullable
    @Attribute(description="A collection of suggested canonical values that MAY be used.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE, multiValueClass=String.class)
    private final Collection<String> canonicalValues;
    @Attribute(description="A Boolean value that specifies if the String attribute is case sensitive.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final boolean caseExact;
    @NotNull
    @Attribute(description="A single keyword indicating the circumstances under which the value of the attribute can be (re)defined.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final Mutability mutability;
    @NotNull
    @Attribute(description="A single keyword that indicates when an attribute and associated values are returned in response to a GET request or in response to a PUT, POST, or PATCH request.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final Returned returned;
    @Nullable
    @Attribute(description="A single keyword value that specifies how the service provider enforces uniqueness of attribute values.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final Uniqueness uniqueness;
    @Nullable
    @Attribute(description="A multi-valued array of JSON strings that indicate the SCIM resource types that may be referenced.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE, multiValueClass=String.class)
    private final Collection<String> referenceTypes;

    @JsonCreator
    AttributeDefinition(@NotNull @JsonProperty(value="name", required=true) String name, @NotNull @JsonProperty(value="type", required=true) Type type, @Nullable @JsonProperty(value="subAttributes") Collection<AttributeDefinition> subAttributes, @JsonProperty(value="multiValued", required=true) boolean multiValued, @Nullable @JsonProperty(value="description") String description, @JsonProperty(value="required", required=true) boolean required, @Nullable @JsonProperty(value="canonicalValues") Collection<String> canonicalValues, @JsonProperty(value="caseExact") boolean caseExact, @NotNull @JsonProperty(value="mutability", required=true) Mutability mutability, @NotNull @JsonProperty(value="returned", required=true) Returned returned, @Nullable @JsonProperty(value="uniqueness") Uniqueness uniqueness, @Nullable @JsonProperty(value="referenceTypes") Collection<String> referenceTypes) {
        this.name = name;
        this.type = type;
        this.subAttributes = subAttributes == null ? null : Collections.unmodifiableList(new ArrayList<AttributeDefinition>(subAttributes));
        this.multiValued = multiValued;
        this.description = description;
        this.required = required;
        this.canonicalValues = canonicalValues == null ? null : Collections.unmodifiableList(new ArrayList<String>(canonicalValues));
        this.caseExact = caseExact;
        this.mutability = mutability;
        this.returned = returned;
        this.uniqueness = uniqueness;
        this.referenceTypes = referenceTypes == null ? null : Collections.unmodifiableList(new ArrayList<String>(referenceTypes));
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isCaseExact() {
        return this.caseExact;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Collection<AttributeDefinition> getSubAttributes() {
        return this.subAttributes;
    }

    @Nullable
    public Collection<String> getCanonicalValues() {
        return this.canonicalValues;
    }

    @NotNull
    public Mutability getMutability() {
        return this.mutability;
    }

    @NotNull
    public Returned getReturned() {
        return this.returned;
    }

    @Nullable
    public Uniqueness getUniqueness() {
        return this.uniqueness;
    }

    @Nullable
    public Collection<String> getReferenceTypes() {
        return this.referenceTypes;
    }

    @NotNull
    public String toString() {
        return this.toIndentedString("");
    }

    @NotNull
    private String toIndentedString(@NotNull String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent);
        builder.append("Name: ");
        builder.append(this.getName());
        builder.append(" Description: ");
        builder.append(this.getDescription());
        builder.append(" Mutability: ");
        builder.append((Object)this.getMutability());
        builder.append(" isRequired: ");
        builder.append(this.isRequired());
        builder.append(" isCaseExact: ");
        builder.append(this.isCaseExact());
        builder.append(System.lineSeparator());
        if (this.getSubAttributes() != null) {
            for (AttributeDefinition a : this.getSubAttributes()) {
                builder.append(a.toIndentedString(indent + "  "));
            }
        }
        return builder.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeDefinition that = (AttributeDefinition)o;
        if (this.caseExact != that.caseExact) {
            return false;
        }
        if (this.multiValued != that.multiValued) {
            return false;
        }
        if (this.required != that.required) {
            return false;
        }
        if (this.canonicalValues != null ? !this.canonicalValues.equals(that.canonicalValues) : that.canonicalValues != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.mutability != null ? !this.mutability.equals((Object)that.mutability) : that.mutability != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.referenceTypes != null ? !this.referenceTypes.equals(that.referenceTypes) : that.referenceTypes != null) {
            return false;
        }
        if (this.returned != null ? !this.returned.equals((Object)that.returned) : that.returned != null) {
            return false;
        }
        if (this.subAttributes != null ? !this.subAttributes.equals(that.subAttributes) : that.subAttributes != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals((Object)that.type) : that.type != null) {
            return false;
        }
        return !(this.uniqueness != null ? !this.uniqueness.equals((Object)that.uniqueness) : that.uniqueness != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.subAttributes != null ? this.subAttributes.hashCode() : 0);
        result = 31 * result + (this.multiValued ? 1 : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.required ? 1 : 0);
        result = 31 * result + (this.canonicalValues != null ? this.canonicalValues.hashCode() : 0);
        result = 31 * result + (this.caseExact ? 1 : 0);
        result = 31 * result + (this.mutability != null ? this.mutability.hashCode() : 0);
        result = 31 * result + (this.returned != null ? this.returned.hashCode() : 0);
        result = 31 * result + (this.uniqueness != null ? this.uniqueness.hashCode() : 0);
        result = 31 * result + (this.referenceTypes != null ? this.referenceTypes.hashCode() : 0);
        return result;
    }

    public static class Builder {
        @Nullable
        private String name;
        @NotNull
        private Type type = Type.STRING;
        @Nullable
        private Collection<AttributeDefinition> subAttributes;
        private boolean multiValued;
        @Nullable
        private String description;
        private boolean required;
        @Nullable
        private Collection<String> canonicalValues;
        private boolean caseExact = false;
        @NotNull
        private Mutability mutability = Mutability.READ_WRITE;
        @NotNull
        private Returned returned = Returned.DEFAULT;
        @Nullable
        private Uniqueness uniqueness = Uniqueness.NONE;
        @Nullable
        private Collection<String> referenceTypes;

        @NotNull
        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        @NotNull
        public Builder setType(@NotNull Type type) {
            this.type = type;
            return this;
        }

        @NotNull
        public Builder addSubAttributes(AttributeDefinition ... subAttributes) {
            if (subAttributes != null && subAttributes.length > 0) {
                if (this.subAttributes == null) {
                    this.subAttributes = new LinkedList<AttributeDefinition>();
                }
                this.subAttributes.addAll(Arrays.asList(subAttributes));
            }
            return this;
        }

        @NotNull
        public Builder setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
            return this;
        }

        @NotNull
        public Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        @NotNull
        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        @NotNull
        public Builder addCanonicalValues(String ... canonicalValues) {
            if (canonicalValues != null && canonicalValues.length > 0) {
                if (this.canonicalValues == null) {
                    this.canonicalValues = new HashSet<String>();
                }
                this.canonicalValues.addAll(Arrays.asList(canonicalValues));
            }
            return this;
        }

        @NotNull
        public Builder setCaseExact(boolean caseExact) {
            this.caseExact = caseExact;
            return this;
        }

        @NotNull
        public Builder setMutability(@NotNull Mutability mutability) {
            this.mutability = mutability;
            return this;
        }

        @NotNull
        public Builder setReturned(@NotNull Returned returned) {
            this.returned = returned;
            return this;
        }

        @NotNull
        public Builder setUniqueness(@Nullable Uniqueness uniqueness) {
            this.uniqueness = uniqueness;
            return this;
        }

        @NotNull
        public Builder addReferenceTypes(String ... referenceTypes) {
            if (referenceTypes != null && referenceTypes.length > 0) {
                if (this.referenceTypes == null) {
                    this.referenceTypes = new HashSet<String>();
                }
                this.referenceTypes.addAll(Arrays.asList(referenceTypes));
            }
            return this;
        }

        @NotNull
        public Builder clear() {
            this.name = null;
            this.type = Type.STRING;
            this.subAttributes = null;
            this.multiValued = false;
            this.description = null;
            this.required = false;
            this.canonicalValues = null;
            this.caseExact = false;
            this.mutability = Mutability.READ_WRITE;
            this.returned = Returned.DEFAULT;
            this.uniqueness = Uniqueness.NONE;
            this.referenceTypes = null;
            return this;
        }

        @NotNull
        public AttributeDefinition build() {
            return new AttributeDefinition(this.name, this.type, this.subAttributes, this.multiValued, this.description, this.required, this.canonicalValues, this.caseExact, this.mutability, this.returned, this.uniqueness, this.referenceTypes);
        }
    }

    public static enum Uniqueness {
        NONE("none"),
        SERVER("server"),
        GLOBAL("global");

        @NotNull
        private String name;

        private Uniqueness(String name) {
            this.name = name;
        }

        @NotNull
        @JsonValue
        public String getName() {
            return this.name;
        }

        @NotNull
        @JsonCreator
        public static Uniqueness fromName(@Nullable String name) throws BadRequestException {
            for (Uniqueness uniqueness : Uniqueness.values()) {
                if (!uniqueness.getName().equalsIgnoreCase(name)) continue;
                return uniqueness;
            }
            throw BadRequestException.invalidSyntax("Unknown SCIM uniquenessConstraint");
        }
    }

    public static enum Returned {
        ALWAYS("always"),
        NEVER("never"),
        DEFAULT("default"),
        REQUEST("request");

        @NotNull
        private String name;

        private Returned(String name) {
            this.name = name;
        }

        @NotNull
        @JsonValue
        public String getName() {
            return this.name;
        }

        @NotNull
        @JsonCreator
        public static Returned fromName(@Nullable String name) throws BadRequestException {
            for (Returned returned : Returned.values()) {
                if (!returned.getName().equalsIgnoreCase(name)) continue;
                return returned;
            }
            throw BadRequestException.invalidSyntax("Unknown SCIM return constraint");
        }
    }

    public static enum Mutability {
        READ_ONLY("readOnly"),
        READ_WRITE("readWrite"),
        IMMUTABLE("immutable"),
        WRITE_ONLY("writeOnly");

        @NotNull
        private String name;

        private Mutability(String name) {
            this.name = name;
        }

        @NotNull
        @JsonValue
        public String getName() {
            return this.name;
        }

        @NotNull
        @JsonCreator
        public static Mutability fromName(@Nullable String name) throws BadRequestException {
            for (Mutability mutability : Mutability.values()) {
                if (!mutability.getName().equalsIgnoreCase(name)) continue;
                return mutability;
            }
            throw BadRequestException.invalidSyntax("Unknown SCIM mutability constraint");
        }
    }

    public static enum Type {
        STRING("string"),
        BOOLEAN("boolean"),
        DECIMAL("decimal"),
        INTEGER("integer"),
        DATETIME("dateTime"),
        BINARY("binary"),
        REFERENCE("reference"),
        COMPLEX("complex");

        @NotNull
        private String name;

        private Type(String name) {
            this.name = name;
        }

        @NotNull
        @JsonValue
        public String getName() {
            return this.name;
        }

        @NotNull
        @JsonCreator
        public static Type fromName(@Nullable String name) {
            for (Type type : Type.values()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return type;
            }
            throw new RuntimeException("Unknown SCIM datatype");
        }
    }
}

