/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.types.AttributeDefinition;

public class Email {
    @Nullable
    @Attribute(description="E-mail addresses for the user. The value\nSHOULD be canonicalized by the Service Provider, e.g.\nbjensen@example.com instead of bjensen@EXAMPLE.COM. Canonical Type\nvalues of work, home, and other.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String value;
    @Nullable
    @Attribute(description="A human readable name, primarily used for display purposes.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String display;
    @Nullable
    @Attribute(description="A label indicating the attribute's function; e.g., 'work' or 'home'.", isRequired=false, isCaseExact=false, canonicalValues={"work", "home", "other"}, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String type;
    @Nullable
    @Attribute(description="A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g., the preferred mailing address or primary e-mail address. The primary attribute value 'true' MUST appear no more than once.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT)
    private Boolean primary;

    @Nullable
    public String getValue() {
        return this.value;
    }

    @NotNull
    public Email setValue(@Nullable String value) {
        this.value = value;
        return this;
    }

    @Nullable
    public String getDisplay() {
        return this.display;
    }

    @NotNull
    public Email setDisplay(@Nullable String display) {
        this.display = display;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @NotNull
    public Email setType(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public Boolean getPrimary() {
        return this.primary;
    }

    @NotNull
    public Email setPrimary(@Nullable Boolean primary) {
        this.primary = primary;
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Email email = (Email)o;
        if (this.value != null ? !this.value.equals(email.value) : email.value != null) {
            return false;
        }
        if (this.display != null ? !this.display.equals(email.display) : email.display != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(email.type) : email.type != null) {
            return false;
        }
        return !(this.primary == null ? email.primary != null : !this.primary.equals(email.primary));
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.display != null ? this.display.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
        return result;
    }
}

