/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.utils.CaseIgnoreMap;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CaseIgnoreObjectNode
extends ObjectNode {
    public CaseIgnoreObjectNode(@NotNull JsonNodeFactory nc) {
        super(nc, (Map)new CaseIgnoreMap());
    }

    public CaseIgnoreObjectNode(@NotNull JsonNodeFactory nc, @NotNull Map<String, JsonNode> kids) {
        super(nc, (Map)new CaseIgnoreMap(kids));
    }

    @NotNull
    public ObjectNode deepCopy() {
        CaseIgnoreObjectNode ret = new CaseIgnoreObjectNode(this._nodeFactory);
        for (Map.Entry entry : this._children.entrySet()) {
            ret._children.put((String)entry.getKey(), ((JsonNode)entry.getValue()).deepCopy());
        }
        return ret;
    }

    @Nullable
    public JsonNode findValue(@NotNull String fieldName) {
        for (Map.Entry entry : this._children.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                return (JsonNode)entry.getValue();
            }
            JsonNode value = ((JsonNode)entry.getValue()).findValue(fieldName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @NotNull
    public List<JsonNode> findValues(@NotNull String fieldName, @Nullable List<JsonNode> foundSoFar) {
        List localFoundSoFar = foundSoFar;
        for (Map.Entry entry : this._children.entrySet()) {
            if (StaticUtils.toLowerCase(fieldName).equals(StaticUtils.toLowerCase((String)entry.getKey()))) {
                if (localFoundSoFar == null) {
                    localFoundSoFar = new ArrayList<JsonNode>();
                }
                localFoundSoFar.add((JsonNode)((JsonNode)entry.getValue()));
                continue;
            }
            localFoundSoFar = ((JsonNode)entry.getValue()).findValues(fieldName, foundSoFar);
        }
        return localFoundSoFar;
    }

    @NotNull
    public List<String> findValuesAsText(@NotNull String fieldName, @Nullable List<String> foundSoFar) {
        List localFoundSoFar = foundSoFar;
        for (Map.Entry entry : this._children.entrySet()) {
            if (StaticUtils.toLowerCase(fieldName).equals(StaticUtils.toLowerCase((String)entry.getKey()))) {
                if (localFoundSoFar == null) {
                    localFoundSoFar = new ArrayList<String>();
                }
                localFoundSoFar.add(((JsonNode)entry.getValue()).asText());
                continue;
            }
            localFoundSoFar = ((JsonNode)entry.getValue()).findValuesAsText(fieldName, foundSoFar);
        }
        return localFoundSoFar;
    }

    @Nullable
    public ObjectNode findParent(@NotNull String fieldName) {
        for (Map.Entry entry : this._children.entrySet()) {
            if (StaticUtils.toLowerCase(fieldName).equals(StaticUtils.toLowerCase((String)entry.getKey()))) {
                return this;
            }
            JsonNode value = ((JsonNode)entry.getValue()).findParent(fieldName);
            if (value == null) continue;
            return (ObjectNode)value;
        }
        return null;
    }

    @NotNull
    public List<JsonNode> findParents(@NotNull String fieldName, @Nullable List<JsonNode> foundSoFar) {
        List localFoundSoFar = foundSoFar;
        for (Map.Entry entry : this._children.entrySet()) {
            if (StaticUtils.toLowerCase(fieldName).equals(StaticUtils.toLowerCase((String)entry.getKey()))) {
                if (localFoundSoFar == null) {
                    localFoundSoFar = new ArrayList<JsonNode>();
                }
                localFoundSoFar.add((JsonNode)this);
                continue;
            }
            localFoundSoFar = ((JsonNode)entry.getValue()).findParents(fieldName, foundSoFar);
        }
        return localFoundSoFar;
    }
}

