/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.SortOrder;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.utils.Debug;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ResourceComparator<T extends ScimResource>
implements Comparator<T> {
    @NotNull
    private final Path sortBy;
    @NotNull
    private final SortOrder sortOrder;
    @Nullable
    private final ResourceTypeDefinition resourceType;

    public ResourceComparator(@NotNull Path sortBy, @Nullable ResourceTypeDefinition resourceType) {
        this(sortBy, SortOrder.ASCENDING, resourceType);
    }

    public ResourceComparator(@NotNull Path sortBy, @Nullable SortOrder sortOrder, @Nullable ResourceTypeDefinition resourceType) {
        this.sortBy = sortBy;
        this.sortOrder = sortOrder == null ? SortOrder.ASCENDING : sortOrder;
        this.resourceType = resourceType;
    }

    @Override
    public int compare(@NotNull T o1, @NotNull T o2) {
        ObjectNode n1 = o1.asGenericScimResource().getObjectNode();
        ObjectNode n2 = o2.asGenericScimResource().getObjectNode();
        JsonNode v1 = null;
        JsonNode v2 = null;
        try {
            List v1s = JsonUtils.findMatchingPaths((Path)this.sortBy, (ObjectNode)n1);
            if (!v1s.isEmpty()) {
                v1 = this.getPrimaryOrFirst((JsonNode)v1s.get(0));
            }
        }
        catch (ScimException e) {
            Debug.debugException((Throwable)e);
        }
        try {
            List v2s = JsonUtils.findMatchingPaths((Path)this.sortBy, (ObjectNode)n2);
            if (!v2s.isEmpty()) {
                v2 = this.getPrimaryOrFirst((JsonNode)v2s.get(0));
            }
        }
        catch (ScimException e) {
            Debug.debugException((Throwable)e);
        }
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return this.sortOrder == SortOrder.ASCENDING ? 1 : -1;
        }
        if (v2 == null) {
            return this.sortOrder == SortOrder.ASCENDING ? -1 : 1;
        }
        AttributeDefinition attributeDefinition = this.resourceType == null ? null : this.resourceType.getAttributeDefinition(this.sortBy);
        return this.sortOrder == SortOrder.ASCENDING ? JsonUtils.compareTo((JsonNode)v1, (JsonNode)v2, (AttributeDefinition)attributeDefinition) : JsonUtils.compareTo((JsonNode)v2, (JsonNode)v1, (AttributeDefinition)attributeDefinition);
    }

    @Nullable
    private JsonNode getPrimaryOrFirst(@NotNull JsonNode node) {
        if (!node.isArray()) {
            return node;
        }
        if (node.size() == 0) {
            return null;
        }
        Iterator i = node.elements();
        while (i.hasNext()) {
            JsonNode value = (JsonNode)i.next();
            JsonNode primary = value.get("primary");
            if (primary == null || !primary.booleanValue()) continue;
            return value;
        }
        return node.get(0);
    }
}

