/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreFinalAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(StoreFinalAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public StoreFinalAction() {
        super("Store a final value");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessageCodec ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequestCodec searchRequest = ldapMessage.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
        if (tlv.getLength() == 0) {
            log.error("The substring final filter is empty");
            throw new DecoderException("The substring final filter is empty");
        }
        String finalValue = StringTools.utf8ToString(tlv.getValue().getData());
        substringFilter.setFinalSubstrings(finalValue);
        searchRequest.unstackFilters(container);
        if (IS_DEBUG) {
            log.debug("Stored a any substring : {}", (Object)finalValue);
        }
    }
}

