/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue.SyncInfoValueTags;
import org.apache.directory.shared.ldap.message.control.replication.SynchronizationInfoEnum;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncInfoValueControlCodec
extends AbstractAsn1Object {
    private SynchronizationInfoEnum type;
    private byte[] cookie;
    private boolean refreshDone = true;
    private boolean refreshDeletes = false;
    private List<byte[]> syncUUIDs;
    private int syncUUIDsLength;
    private int syncInfoValueLength;

    public SyncInfoValueControlCodec(SynchronizationInfoEnum type) {
        this.type = type;
        if (type == SynchronizationInfoEnum.SYNC_ID_SET) {
            this.syncUUIDs = new ArrayList<byte[]>();
        }
    }

    public SynchronizationInfoEnum getType() {
        return this.type;
    }

    public void setType(SynchronizationInfoEnum type) {
        this.type = type;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public boolean isRefreshDone() {
        return this.refreshDone;
    }

    public void setRefreshDone(boolean refreshDone) {
        this.refreshDone = refreshDone;
    }

    public boolean isRefreshDeletes() {
        return this.refreshDeletes;
    }

    public void setRefreshDeletes(boolean refreshDeletes) {
        this.refreshDeletes = refreshDeletes;
    }

    public List<byte[]> getSyncUUIDs() {
        return this.syncUUIDs;
    }

    public void setSyncUUIDs(List<byte[]> syncUUIDs) {
        this.syncUUIDs = syncUUIDs;
    }

    public int computeLength() {
        this.syncInfoValueLength = 0;
        switch (this.type) {
            case NEW_COOKIE: {
                this.syncInfoValueLength = this.cookie != null ? 1 + TLV.getNbBytes((int)this.cookie.length) + this.cookie.length : 2;
                return this.syncInfoValueLength;
            }
            case REFRESH_DELETE: 
            case REFRESH_PRESENT: {
                if (this.cookie != null) {
                    this.syncInfoValueLength = 1 + TLV.getNbBytes((int)this.cookie.length) + this.cookie.length;
                }
                this.syncInfoValueLength += 3;
                break;
            }
            case SYNC_ID_SET: {
                if (this.cookie != null) {
                    this.syncInfoValueLength = 1 + TLV.getNbBytes((int)this.cookie.length) + this.cookie.length;
                }
                this.syncInfoValueLength += 3;
                this.syncUUIDsLength = 0;
                if (this.syncUUIDs.size() != 0) {
                    for (byte[] syncUUID : this.syncUUIDs) {
                        int uuidLength = 1 + TLV.getNbBytes((int)syncUUID.length) + syncUUID.length;
                        this.syncUUIDsLength += 1 + TLV.getNbBytes((int)uuidLength) + uuidLength;
                    }
                    this.syncUUIDsLength += 1 + TLV.getNbBytes((int)this.syncUUIDsLength) + this.syncUUIDsLength;
                }
                this.syncInfoValueLength += 1 + TLV.getNbBytes((int)this.syncUUIDsLength) + this.syncUUIDsLength;
            }
        }
        return 1 + TLV.getNbBytes((int)this.syncInfoValueLength) + this.syncInfoValueLength;
    }

    public ByteBuffer encode(ByteBuffer bb) throws EncoderException {
        if (bb == null) {
            bb = ByteBuffer.allocate(this.computeLength());
        }
        switch (this.type) {
            case NEW_COOKIE: {
                bb.put((byte)SyncInfoValueTags.NEW_COOKIE_TAG.getValue());
                if (this.cookie == null || this.cookie.length == 0) {
                    bb.put((byte)0);
                    break;
                }
                bb.put(TLV.getBytes((int)this.cookie.length));
                bb.put(this.cookie);
                break;
            }
            case REFRESH_DELETE: {
                bb.put((byte)SyncInfoValueTags.REFRESH_DELETE_TAG.getValue());
                bb.put(TLV.getBytes((int)this.syncInfoValueLength));
                if (this.cookie != null) {
                    Value.encode((ByteBuffer)bb, (byte[])this.cookie);
                }
                Value.encode((ByteBuffer)bb, (boolean)this.refreshDone);
                break;
            }
            case REFRESH_PRESENT: {
                bb.put((byte)SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue());
                bb.put(TLV.getBytes((int)this.syncInfoValueLength));
                if (this.cookie != null) {
                    Value.encode((ByteBuffer)bb, (byte[])this.cookie);
                }
                Value.encode((ByteBuffer)bb, (boolean)this.refreshDone);
                break;
            }
            case SYNC_ID_SET: {
                bb.put((byte)SyncInfoValueTags.SYNC_ID_SET_TAG.getValue());
                bb.put(TLV.getBytes((int)this.syncInfoValueLength));
                if (this.cookie != null) {
                    Value.encode((ByteBuffer)bb, (byte[])this.cookie);
                }
                Value.encode((ByteBuffer)bb, (boolean)this.refreshDeletes);
                bb.put((byte)49);
                bb.put(TLV.getBytes((int)this.syncUUIDsLength));
                if (this.syncUUIDs.size() == 0) break;
                for (byte[] syncUUID : this.syncUUIDs) {
                    Value.encode((ByteBuffer)bb, (byte[])syncUUID);
                }
                break;
            }
        }
        return bb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncInfoValue control :\n");
        switch (this.type) {
            case NEW_COOKIE: {
                sb.append("        newCookie : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
                break;
            }
            case REFRESH_DELETE: {
                sb.append("        refreshDelete : \n");
                if (this.cookie != null) {
                    sb.append("            cookie : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
                }
                sb.append("            refreshDone : ").append(this.refreshDone).append('\n');
                break;
            }
            case REFRESH_PRESENT: {
                sb.append("        refreshPresent : \n");
                if (this.cookie != null) {
                    sb.append("            cookie : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
                }
                sb.append("            refreshDone : ").append(this.refreshDone).append('\n');
                break;
            }
            case SYNC_ID_SET: {
                sb.append("        syncIdSet : \n");
                if (this.cookie != null) {
                    sb.append("            cookie : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
                }
                sb.append("            refreshDeletes : ").append(this.refreshDeletes).append('\n');
                sb.append("            syncUUIDS : ");
                if (this.syncUUIDs.size() != 0) {
                    boolean isFirst = true;
                    for (byte[] syncUUID : this.syncUUIDs) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(syncUUID);
                    }
                    sb.append('\n');
                    break;
                }
                sb.append("empty\n");
            }
        }
        return sb.toString();
    }
}

