/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.AssertionType;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.LeafNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleNode
extends LeafNode {
    private Value<?> value;
    private String matchingRuleId;
    private boolean dnAttributes = false;

    public ExtensibleNode(String attribute) {
        super(attribute, AssertionType.EXTENSIBLE);
        this.dnAttributes = false;
    }

    public ExtensibleNode(String attribute, Value<?> value, String matchingRuleId, boolean dnAttributes) {
        super(attribute, AssertionType.EXTENSIBLE);
        this.value = value;
        this.matchingRuleId = matchingRuleId;
        this.dnAttributes = dnAttributes;
    }

    @Override
    public ExprNode clone() {
        ExprNode clone = super.clone();
        if (this.value != null) {
            ((ExtensibleNode)clone).value = this.value.clone();
        }
        return clone;
    }

    public boolean hasDnAttributes() {
        return this.dnAttributes;
    }

    public void setDnAttributes(boolean dnAttributes) {
        this.dnAttributes = dnAttributes;
    }

    public String getMatchingRuleId() {
        return this.matchingRuleId;
    }

    public void setMatchingRuleId(String matchingRuleId) {
        this.matchingRuleId = matchingRuleId;
    }

    public final Value<?> getValue() {
        return this.value;
    }

    public Value<?> getEscapedValue() {
        if (!this.value.isBinary()) {
            return AbstractExprNode.escapeFilterValue(this.value);
        }
        return this.value;
    }

    public final void setValue(Value<?> value) {
        this.value = value;
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.dnAttributes ? 1 : 0);
        h = h * 17 + this.matchingRuleId.hashCode();
        h = h * 17 + this.value.hashCode();
        return h;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(').append(this.getAttribute());
        buf.append("-");
        buf.append(this.dnAttributes);
        buf.append("-EXTENSIBLE-");
        buf.append(this.matchingRuleId);
        buf.append("-");
        buf.append(this.value);
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

