/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.Arrays;
import org.apache.directory.shared.ldap.message.InternalAbstractResultResponse;
import org.apache.directory.shared.ldap.message.InternalExtendedResponse;

public class ExtendedResponseImpl
extends InternalAbstractResultResponse
implements InternalExtendedResponse {
    static final long serialVersionUID = -6646752766410531060L;
    protected String oid;
    protected byte[] value;

    public ExtendedResponseImpl(int id, String oid) {
        super(id, TYPE);
        this.oid = oid;
    }

    public ExtendedResponseImpl(int id) {
        super(id, TYPE);
    }

    public byte[] getResponse() {
        if (this.value == null) {
            return null;
        }
        byte[] copy = new byte[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, this.value.length);
        return copy;
    }

    public void setResponse(byte[] value) {
        if (value != null) {
            this.value = new byte[value.length];
            System.arraycopy(value, 0, this.value, 0, value.length);
        } else {
            this.value = null;
        }
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getResponseName() {
        return this.oid;
    }

    public void setResponseName(String oid) {
        this.oid = oid;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof InternalExtendedResponse)) {
            return false;
        }
        InternalExtendedResponse resp = (InternalExtendedResponse)obj;
        if (this.oid != null && resp.getResponseName() == null) {
            return false;
        }
        if (this.oid == null && resp.getResponseName() != null) {
            return false;
        }
        if (this.oid != null && resp.getResponseName() != null && !this.oid.equals(resp.getResponseName())) {
            return false;
        }
        if (this.value != null && resp.getResponse() == null) {
            return false;
        }
        if (this.value == null && resp.getResponse() != null) {
            return false;
        }
        return this.value == null || resp.getResponse() == null || Arrays.equals(this.value, resp.getResponse());
    }

    public String getID() {
        return this.getResponseName();
    }

    public byte[] getEncodedValue() {
        return this.getResponse();
    }
}

