/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.parsers;

import java.util.List;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;

public class ParserDescriptionUtils {
    public static boolean objectClassesMatch(ObjectClassDescription ocd0, ObjectClassDescription ocd1) {
        int ii;
        if (!ParserDescriptionUtils.descriptionsMatch(ocd0, ocd1)) {
            return false;
        }
        if (ocd0.getKind() != ocd1.getKind()) {
            return false;
        }
        if (ocd0.getSuperiorObjectClasses().size() != ocd1.getSuperiorObjectClasses().size()) {
            return false;
        }
        for (ii = 0; ii < ocd0.getSuperiorObjectClasses().size(); ++ii) {
            if (ocd0.getSuperiorObjectClasses().get(ii).equals(ocd1.getSuperiorObjectClasses().get(ii))) continue;
            return false;
        }
        for (ii = 0; ii < ocd0.getMustAttributeTypes().size(); ++ii) {
            if (ocd0.getMustAttributeTypes().get(ii).equals(ocd1.getMustAttributeTypes().get(ii))) continue;
            return false;
        }
        for (ii = 0; ii < ocd0.getMayAttributeTypes().size(); ++ii) {
            if (ocd0.getMayAttributeTypes().get(ii).equals(ocd1.getMayAttributeTypes().get(ii))) continue;
            return false;
        }
        return true;
    }

    public static boolean attributeTypesMatch(AttributeTypeDescription atd0, AttributeTypeDescription atd1) {
        if (!ParserDescriptionUtils.descriptionsMatch(atd0, atd1)) {
            return false;
        }
        if (!atd0.getSuperType().equals(atd1.getSuperType())) {
            return false;
        }
        if (!atd0.getEqualityMatchingRule().equals(atd1.getEqualityMatchingRule())) {
            return false;
        }
        if (!atd0.getSubstringsMatchingRule().equals(atd1.getSubstringsMatchingRule())) {
            return false;
        }
        if (!atd0.getOrderingMatchingRule().equals(atd1.getOrderingMatchingRule())) {
            return false;
        }
        if (!atd0.getSyntax().equals(atd1.getSyntax())) {
            return false;
        }
        if (atd0.getSyntaxLength() != atd1.getSyntaxLength()) {
            return false;
        }
        if (atd0.isSingleValued() != atd1.isSingleValued()) {
            return false;
        }
        if (atd0.isCollective() != atd1.isCollective()) {
            return false;
        }
        if (atd0.isUserModifiable() != atd1.isUserModifiable()) {
            return false;
        }
        return atd0.getUsage() == atd1.getUsage();
    }

    public static boolean matchingRulesMatch(MatchingRuleDescription mrd0, MatchingRuleDescription mrd1) {
        if (!ParserDescriptionUtils.descriptionsMatch(mrd0, mrd1)) {
            return false;
        }
        return mrd0.getSyntax().equals(mrd1.getSyntax());
    }

    public static boolean syntaxesMatch(LdapSyntaxDescription lsd0, LdapSyntaxDescription lsd1) {
        return ParserDescriptionUtils.descriptionsMatch(lsd0, lsd1);
    }

    public static boolean descriptionsMatch(AbstractSchemaDescription asd0, AbstractSchemaDescription asd1) {
        if (!asd0.getNumericOid().equals(asd1.getNumericOid())) {
            return false;
        }
        if ((asd0 instanceof LdapSyntaxDescription || asd1 instanceof LdapSyntaxDescription) && asd0.isObsolete() != asd1.isObsolete()) {
            return false;
        }
        if (!asd0.getDescription().equals(asd1.getDescription())) {
            return false;
        }
        if (!ParserDescriptionUtils.aliasNamesMatch(asd0, asd1)) {
            return false;
        }
        return ParserDescriptionUtils.extensionsMatch(asd0, asd1);
    }

    public static boolean extensionsMatch(AbstractSchemaDescription asd0, AbstractSchemaDescription asd1) {
        if (asd0.getExtensions().size() != asd1.getExtensions().size()) {
            return false;
        }
        for (String key : asd0.getExtensions().keySet()) {
            List<String> values0 = asd0.getExtensions().get(key);
            List<String> values1 = asd1.getExtensions().get(key);
            if (values1 == null) {
                return false;
            }
            for (int ii = 0; ii < values0.size(); ++ii) {
                if (values0.get(ii).equals(values1.get(ii))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean aliasNamesMatch(AbstractSchemaDescription asd0, AbstractSchemaDescription asd1) {
        if (asd0.getNames().size() != asd1.getNames().size()) {
            return false;
        }
        for (int ii = 0; ii < asd0.getNames().size(); ++ii) {
            if (asd0.getNames().get(ii).equals(asd1.getNames().get(ii))) continue;
            return false;
        }
        return true;
    }
}

